## Online configurator

The device is configurable over LoRaWAN. To help generate a configuration, our [NEON Configurator](https://neon-configurator.twtg.io/neon/tt/v3/) can be used. This configurator is an online form with all possible settings within their allowed ranges. After tailoring the settings to your application you can then generate a LoRaWAN message to be sent via your network server.

## Conversion examples

The examples below are generated using the Javascript files in the example folder using [nodejs](https://nodejs.org/) (a Linux application to execute Javascript files).

### Encoding TT protocol v3

Generated by:
```
nodejs ./examples/encoder_tt_prot-3_examples.js
```

#### Device config message
JSON:
```
{
    "header": {
        "message_type": "base_configuration",
        "protocol_version": 3
    },
    "switch_mask": {
        "enable_confirmed_event_message": false
    },
    "communication_max_retries": 3,
    "number_of_unconfirmed_messages": 1,
    "periodic_message_random_delay_seconds": 60,
    "status_message_interval_seconds": 86400,
    "status_message_confirmed_interval": 1,
    "lora_failure_holdoff_count": 5,
    "lora_system_recover_count": 1,
    "lorawan_fsb_mask": [
        "0x00FF",
        "0x0000",
        "0x0000",
        "0x0000",
        "0x0001"
    ]
}
```
Bytestring (hexidecimal):
```
350003013ca005010501ff000000000000000100d281
```
#### Application config message
JSON:
```
{
    "header": {
        "message_type": "sensor_configuration",
        "protocol_version": 3
    },
    "device_type": "tt",
    "sensor_type": "K",
    "temperature_measurement_interval_seconds": 900,
    "periodic_event_message_interval": 16,
    "events": [
        {
            "mode": "off",
            "threshold_temperature": 0,
            "measurement_window": 0
        },
        {
            "mode": "off",
            "threshold_temperature": 0,
            "measurement_window": 0
        },
        {
            "mode": "off",
            "threshold_temperature": 0,
            "measurement_window": 0
        },
        {
            "mode": "off",
            "threshold_temperature": 0,
            "measurement_window": 0
        }
    ]
}
```
Bytestring (hexidecimal):
```
3604028403100000000000000000000000000000000000a6ad
```
#### Application config message (pattern)
JSON:
```
{
    "header": {
        "message_type": "sensor_configuration",
        "protocol_version": 3
    },
    "device_type": "tt",
    "sensor_type": "K",
    "temperature_measurement_interval_seconds": 30,
    "periodic_event_message_interval": 20,
    "events": [
        {
            "mode": "above",
            "threshold_temperature": 54.9,
            "measurement_window": 1
        },
        {
            "mode": "below",
            "threshold_temperature": -14.9,
            "measurement_window": 1
        },
        {
            "mode": "increasing",
            "threshold_temperature": 9.9,
            "measurement_window": 20
        },
        {
            "mode": "decreasing",
            "threshold_temperature": 9.9,
            "measurement_window": 20
        }
    ]
}
```
Bytestring (hexidecimal):
```
3604021e00140001250201026bff010363001404630014aca1
```

### Decoding TT protocol v3

Generated by:
```
nodejs ./examples/decoder_tt_prot-3_examples.js
```

#### Boot message
Bytestring (hexidecimal):
```
3004443322110100020003040610203040506070800708
```
JSON:
```
{
    "header": {
        "protocol_version": 3,
        "message_type": "boot"
    },
    "boot": {
        "device_type": "tt",
        "version_hash": "0x11223344",
        "base_config_crc": "0x0001",
        "sensor_config_crc": "0x0002",
        "reset_flags": "0x03",
        "reboot_counter": 4,
        "reboot_info": "unknown (0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80)",
        "last_device_state": 7,
        "bist": "0x08"
    }
}
```
#### Activated message
Bytestring (hexidecimal):
```
31
```
JSON:
```
{
    "header": {
        "protocol_version": 3,
        "message_type": "activated"
    }
}
```
#### Deactivated message
Bytestring (hexidecimal):
```
32
```
JSON:
```
{
    "header": {
        "protocol_version": 3,
        "message_type": "deactivated"
    }
}
```
#### Application event message (pattern 1)
Bytestring (hexidecimal):
```
330102000300040005
```
JSON:
```
{
    "header": {
        "protocol_version": 3,
        "message_type": "sensor_event"
    },
    "sensor_event": {
        "trigger": "condition_0",
        "temperature": {
            "min": 0.2,
            "max": 0.3,
            "avg": 0.4,
            "status": "OK"
        },
        "condition_0": 1,
        "condition_1": 0,
        "condition_2": 1,
        "condition_3": 0
    }
}
```
#### Application event message (pattern 2)
Bytestring (hexidecimal):
```
330474f54448d70009
```
JSON:
```
{
    "header": {
        "protocol_version": 3,
        "message_type": "sensor_event"
    },
    "sensor_event": {
        "trigger": "condition_3",
        "temperature": {
            "min": -270,
            "max": 1850,
            "avg": 21.5,
            "status": "OK"
        },
        "condition_0": 1,
        "condition_1": 0,
        "condition_2": 0,
        "condition_3": 1
    }
}
```
#### Device status message (pattern 1)
Bytestring (hexidecimal):
```
34cdab3412030b000c000d00151617060708
```
JSON:
```
{
    "header": {
        "protocol_version": 3,
        "message_type": "device_status"
    },
    "device_status": {
        "base_config_crc": "0xABCD",
        "sensor_config_crc": "0x1234",
        "event_counter": 3,
        "battery_voltage": {
            "low": 0.011,
            "high": 0.012,
            "settle": 0.013
        },
        "temperature": {
            "min": 21,
            "max": 22,
            "avg": 23
        },
        "tx_counter": 6,
        "avg_rssi": -7,
        "avg_snr": 8
    }
}
```
#### Device status message (pattern 2)
Bytestring (hexidecimal):
```
343412cdabffa00f100e5e0ed850157b4bf6
```
JSON:
```
{
    "header": {
        "protocol_version": 3,
        "message_type": "device_status"
    },
    "device_status": {
        "base_config_crc": "0x1234",
        "sensor_config_crc": "0xABCD",
        "event_counter": 255,
        "battery_voltage": {
            "low": 4,
            "high": 3.6,
            "settle": 3.678
        },
        "temperature": {
            "min": -40,
            "max": 80,
            "avg": 21
        },
        "tx_counter": 123,
        "avg_rssi": -75,
        "avg_snr": -10
    }
}
```
